﻿/*	VERSION:	1.1

1.1:		Added to "wait" command:  'movieclip'  and  'script'

AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
#include "gameFunctions/getPathValue.as"

define_wait = function(command_obj)
{
	command_obj.animDone = function(){
		SPRITES[this.spriteName].image.removeListener(this);
		this.spriteName = null;		delete this.spriteName;
		this.nextEvent();
	}// animDone()
	command_obj.run = function( thisCommand_obj )
	{
		var waitMode = thisCommand_obj.data.mode;
		if(TRACE_SCRIPT)
			trace("wait for: "+waitMode);
		
		if(waitMode=="time")
		{
			var waitId = setTimeout( thisCommand_obj.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
		}// if:  time
		
		
		
		if(waitMode=="movement")
		{
			var spriteName = thisCommand_obj.data.value;
			// make a list of sprites to wait for
			thisCommand_obj.spritesLeft = [];
			if(spriteName == "ALL")
			{// if:  wait for all sprites to finish moving
				for(var nam in SPRITES)
				{// for:  every sprite
					var sprite = SPRITES[nam];
					if(sprite.lastMove)
					{// if:  this sprite is moving
						var waitObject = {
							sprite:sprite,
							thisCommand_obj:thisCommand_obj
						}// waitObject
						thisCommand_obj.spritesLeft.push(waitObject);
					}// if:  this sprite is moving
				}// for:  every sprite
			}// if:  wait for all sprites to finish moving
			else
			{// if:  wait for a specific sprite
				if(spriteName == "this")
					spriteName = _this._name;		// read the instance name of the rpgSprite that contains this script
				var sprite = SPRITES[spriteName];
				if(sprite.lastMove)
				{// if:  this sprite is moving
					var waitObject = {
						sprite:sprite,
						thisCommand_obj:thisCommand_obj
					}// waitObject
					thisCommand_obj.spritesLeft.push(waitObject);
				}// if:  this sprite is moving
			}// if:  wait for a specific sprite
			
			
			// wait for each sprite in the list
			if(thisCommand_obj.spritesLeft.length > 0)
			{// if:  there are sprites to wait for
				for(var nam in thisCommand_obj.spritesLeft)
				{// for:  each sprite in the list
					var waitObject = thisCommand_obj.spritesLeft[nam];
					var sprite = waitObject.sprite;
					waitObject.onMotionFinished = function()
					{
						this.sprite.lastMove.removeListener( this );
						this.thisCommand_obj.spritesLeft.pop();
						if(this.thisCommand_obj.spritesLeft.length<=0)		// when there are no more sprites left to wait for
							setTimeout( this.thisCommand_obj.nextEvent, 34 );
					}// onMotionFinished()
					sprite.lastMove.addListener( waitObject );
				}// for:  each sprite in the list
			}// if:  there are sprites to wait for
			else
			{// if:  there's nothing to wait for
				thisCommand_obj.nextEvent();
			}// if:  there's nothing to wait for
		}// if:  movement
		
		
		
		if(waitMode=="animation")
		{
			var spriteName = thisCommand_obj.data.value;
			if(spriteName=="this")		spriteName=_this._name;
			thisCommand_obj.spriteName = spriteName;
			// if:  not already on the last frame
			var frame = SPRITES[spriteName].image.getParam("frame");
			var frames = SPRITES[spriteName].image.getParam("frames");
			if(frame<frames)
				SPRITES[spriteName].image.addListener(this);
			else
				thisCommand_obj.nextEvent();
		}// if:  animation
		
		
		
		if(waitMode=="movieclip")
		{
			// resolve the movieclip path
			var path = thisCommand_obj.data.value;
			if( path=="this" )
				path = "SPRITES."+_this._name;
			if( path.substr(0,5) == "this." ){
				var theRest = path.substr(5);
				path = "SPRITES."+_this._name +"." +theRest;
			}
			var newClip = getPathValue( path,  ("SPRITES." +_this._name)  );
			var isMovieclip = (typeof(newClip) == "movieclip");
			
			if(isMovieclip)
			{// if:  is a movieClip
				// inject wait code into the movieclip
				newClip.detectLastFrame = {
					levelId:ROOT.game_mc.uid,
					parent:newClip,
					loop:function( thisObj )		// repeatedly check for last frame
					{
						var sameLevel = (thisObj.levelId == ROOT.game_mc.uid);
						if(	thisObj.parent._currentframe == thisObj.parent._totalframes
						||	thisObj.parent._currentframe == undefined
						||	sameLevel == false){
							// stop checking for last frame
							if(thisObj.intervalId != null)		clearInterval( thisObj.intervalId );
							// remove this code from the target movieClip
							newClip.detectLastFrame = null;
							delete newClip.detectLastFrame;
							// start next event
							if(sameLevel){
								thisCommand_obj.nextEvent();
							}
						}// if:  last frame
					},// loop()
					intervalId:null,
					start:function(){		// begin loop
						if(this.intervalId!=null)
							clearInterval( this.intervalId );
						this.intervalId = setInterval( this.loop, 34, this );
						this.loop();
					}// start()
				}// detectLastFrame obj
				newClip.detectLastFrame.start();		// start checking for the last frame
			}// if:  is a movieClip
			else
			{// if:  not a movieClip
				thisCommand_obj.nextEvent();
			}// if:  not a movieClip
		}// if:  movieclip

		
		
		
		if(waitMode=="fadeMusic")
		{
			command_obj.storeTimeout( 999 );
			command_obj.onFadeComplete = function(){
				MUSIC.removeListener(thisCommand_obj);
				//if( this.getTimeout()!=null){		// if:  this sprite was not externally removed
					command_obj.nextEvent();
				//}// if:  this sprite was not externally removed
			}// onFadeComplete()
			
			if(!MUSIC.isFading){
				command_obj.onFadeComplete();			// resume immediately
			}// if:  there's no fade to wait for
			else
			{// if:  music is fading
				MUSIC.addListener(command_obj);		// react to music fade
			}// if:  music is fading
		}// if:  fadeMusic
		
		
		
		if(waitMode=="sound")
		{
			// continue when specified sound ends
			var soundDone = {
				onSoundComplete:function(){
					thisCommand_obj.nextEvent();
				}// onSoundComplete()
			}// soundDone obj
			// add listener to specified sound
			ROOT.soundLoop[thisCommand_obj.data.value].sound.addListener(soundDone);
		}// if:  sound
		
		
		
		if(waitMode=="script")
		{
			var spriteName = thisCommand_obj.data.value;
			if(spriteName=="this")		spriteName=_this._name;
			// resolve [] variables
			spriteName = nestedEval( spriteName, "RAM", "_this" );
			// get a direct refernce to the specified sprite
			var sprite_mc = getPathValue( spriteName, SPRITES );
			//var sprite_mc = SPRITES[spriteName];
			var scriptName = thisCommand_obj.data.value2;
			if(sprite_mc && scriptName)
			{// if:  sprite exists
				var thisScript = sprite_mc.scripts[scriptName];
				if(thisScript)
				{// if:  script exists
					if(thisScript.isDone == false)
					{// if:  script is running
						var waitObj = {};
						waitObj.onScriptDone = function(){
							thisScript.removeListener(waitObj);
							thisCommand_obj.nextEvent();
						}// script done()
						thisScript.addListener(waitObj);
					}// if:  script is running
				}// if:  script exists
			}// if:  sprite exists
			else
			{// if:  no such sprite
				thisCommand_obj.nextEvent();
			}// if:  no such sprite
			
			//thisCommand_obj.nextEvent();
		}// if:  animation
	}// run()
	command_obj.scriptBase = scriptBase;
	command_obj.getTimeout = function(){
		return this.scriptBase.timeoutID;
	}
}// define_wait()